/*------------------------------------------------------------------------------*
 * File Name: AccessingArraysOfDatasets.c										*
 * Creation: GJL 10/22/03														*
 * Purpose: OriginC Source C file containing AccessingArrayOfDatasets examples.	*
 * Copyright (c) OriginLab Corp.	2003, 2004, 2005, 2006, 2007				*
 * All Rights Reserved															*
 *------------------------------------------------------------------------------*/
 
#include <Origin.h>

BOOL AccessingStaticArrayOfDatasets()
{
	Worksheet wks = Project.ActiveLayer(); // Get active worksheet layer
	if( wks.IsValid() ) // If wks is valid..
	{
		uint nCols = wks.Columns.Count(); // Get number of columns in worksheet
		nCols = nCols > 10 ? 10 : nCols; // Maximum number of columns is 10
		Dataset ards[10]; // Declare an array of datasets
		for( int ii = 0; ii < nCols; ii++ ) // For each column in worksheet...
		{
			ards[ii].Attach(wks, ii); // Attach to Dataset in ii-th column
			if( !ards[ii].IsValid() ) // Continue if attach fails
				continue;
			string strName = ards[ii].GetName(); // Get name of ii-th Dataset
			int iSize = ards[ii].GetSize(); // Get size of ii-th Dataset
			if( iSize > 0 )
			{
				double dFirstVal = ards[ii][0]; // Get first value of ii-th Dataset
				printf("Dataset %s has %d elements the first of which is %g\n", strName, iSize, dFirstVal);
			}
			else
				printf("Dataset %s has %d elements\n", strName, iSize);
		}
		return TRUE;
	}

	return FALSE;
}

// Not yet supported as of v7.5727
//BOOL AccessingDynamicArrayOfDatasets()
//{
	//Worksheet wks = Project.ActiveLayer(); // Get active worksheet layer
	//if( wks.IsValid() ) // If wks is valid..
	//{
		//uint nCols = wks.Columns.Count(); // Get number of columns in worksheet
		//Dataset *pards = new Dataset[nCols]; // Declare a pointer to an array of datasets
		//if( NULL == pards ) // If allocation unsuccessful...
		//{
			//out_str("Array Allocation failed!");
			//return FALSE;
		//}	
		//for( int ii = 0; ii < nCols; ii++ ) // For each column in worksheet...
		//{
			//*pards[ii].Attach(wks, ii); // Attach to Dataset in ii-th column
			//if( !*pards[ii].IsValid() ) // Return if attach fails
				//continue;
			//string strName = *pards[ii].GetName(); // Get name of ii-th Dataset
			//int iSize = *pards[ii].GetSize(); // Get size of ii-th Dataset
			//if( iSize > 0 )
			//{
				//double dFirstVal = *pards[ii][0]; // Get first value of ii-th Dataset
				//printf("Dataset %s has %d elements the first of which is %g\n", strName, iSize, dFirstVal);
			//}
			//else
				//printf("Dataset %s has %d elements\n", strName, iSize);
		//}
		//delete pards;
		//return TRUE;
	//}
//
	//return FALSE;
//}
